Imports OPC
Imports OPCDA
Imports OPCDA.NET


Public Class Form1

    Inherits System.Windows.Forms.Form

    '================================================================
    ' OPC Server Access Sample Code
    '------------------------------
    Public OpcSrv As OpcServer = Nothing
    Public srwGroup As SyncIOGroup = Nothing

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents ConnectOPC As System.Windows.Forms.Button
    Friend WithEvents Disconnect As System.Windows.Forms.Button
    Friend WithEvents Timer1 As System.Windows.Forms.Timer
    Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
    Friend WithEvents TextBox2 As System.Windows.Forms.TextBox
    Friend WithEvents TextBox3 As System.Windows.Forms.TextBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents TextBox4 As System.Windows.Forms.TextBox
    Friend WithEvents SetSpeed1 As System.Windows.Forms.Button
    Friend WithEvents SetSpeed2 As System.Windows.Forms.Button
    Friend WithEvents TextBox5 As System.Windows.Forms.TextBox
    Friend WithEvents Label4 As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.ConnectOPC = New System.Windows.Forms.Button
        Me.Label1 = New System.Windows.Forms.Label
        Me.Disconnect = New System.Windows.Forms.Button
        Me.Timer1 = New System.Windows.Forms.Timer(Me.components)
        Me.TextBox1 = New System.Windows.Forms.TextBox
        Me.TextBox2 = New System.Windows.Forms.TextBox
        Me.TextBox3 = New System.Windows.Forms.TextBox
        Me.Label2 = New System.Windows.Forms.Label
        Me.Label3 = New System.Windows.Forms.Label
        Me.SetSpeed1 = New System.Windows.Forms.Button
        Me.SetSpeed2 = New System.Windows.Forms.Button
        Me.TextBox4 = New System.Windows.Forms.TextBox
        Me.TextBox5 = New System.Windows.Forms.TextBox
        Me.Label4 = New System.Windows.Forms.Label
        Me.SuspendLayout()
        '
        'ConnectOPC
        '
        Me.ConnectOPC.Location = New System.Drawing.Point(16, 16)
        Me.ConnectOPC.Name = "ConnectOPC"
        Me.ConnectOPC.Size = New System.Drawing.Size(120, 40)
        Me.ConnectOPC.TabIndex = 0
        Me.ConnectOPC.Text = "Connect OPC Server"
        '
        'Label1
        '
        Me.Label1.Font = New System.Drawing.Font("Arial Black", 10.2!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Label1.Location = New System.Drawing.Point(160, 24)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(432, 24)
        Me.Label1.TabIndex = 1
        Me.Label1.Text = "Not Connected"
        '
        'Disconnect
        '
        Me.Disconnect.Location = New System.Drawing.Point(496, 376)
        Me.Disconnect.Name = "Disconnect"
        Me.Disconnect.Size = New System.Drawing.Size(112, 32)
        Me.Disconnect.TabIndex = 2
        Me.Disconnect.Text = "Disconnect"
        '
        'Timer1
        '
        Me.Timer1.Interval = 20
        '
        'TextBox1
        '
        Me.TextBox1.Location = New System.Drawing.Point(264, 160)
        Me.TextBox1.Name = "TextBox1"
        Me.TextBox1.Size = New System.Drawing.Size(224, 22)
        Me.TextBox1.TabIndex = 3
        Me.TextBox1.Text = "0"
        '
        'TextBox2
        '
        Me.TextBox2.Location = New System.Drawing.Point(264, 200)
        Me.TextBox2.Name = "TextBox2"
        Me.TextBox2.Size = New System.Drawing.Size(224, 22)
        Me.TextBox2.TabIndex = 4
        Me.TextBox2.Text = "0"
        '
        'TextBox3
        '
        Me.TextBox3.Location = New System.Drawing.Point(264, 240)
        Me.TextBox3.Name = "TextBox3"
        Me.TextBox3.Size = New System.Drawing.Size(224, 22)
        Me.TextBox3.TabIndex = 5
        Me.TextBox3.Text = "360"
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(144, 160)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(96, 24)
        Me.Label2.TabIndex = 6
        Me.Label2.Text = "position1 (deg)"
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(144, 200)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(96, 24)
        Me.Label3.TabIndex = 7
        Me.Label3.Text = "position2 (deg)"
        '
        'SetSpeed1
        '
        Me.SetSpeed1.Location = New System.Drawing.Point(96, 240)
        Me.SetSpeed1.Name = "SetSpeed1"
        Me.SetSpeed1.Size = New System.Drawing.Size(152, 24)
        Me.SetSpeed1.TabIndex = 9
        Me.SetSpeed1.Text = "Set Jog_Speed1"
        '
        'SetSpeed2
        '
        Me.SetSpeed2.Location = New System.Drawing.Point(96, 272)
        Me.SetSpeed2.Name = "SetSpeed2"
        Me.SetSpeed2.Size = New System.Drawing.Size(152, 24)
        Me.SetSpeed2.TabIndex = 12
        Me.SetSpeed2.Text = "Set Jog_Speed2"
        '
        'TextBox4
        '
        Me.TextBox4.Location = New System.Drawing.Point(264, 272)
        Me.TextBox4.Name = "TextBox4"
        Me.TextBox4.Size = New System.Drawing.Size(224, 22)
        Me.TextBox4.TabIndex = 10
        Me.TextBox4.Text = "360"
        '
        'TextBox5
        '
        Me.TextBox5.Location = New System.Drawing.Point(120, 72)
        Me.TextBox5.Name = "TextBox5"
        Me.TextBox5.Size = New System.Drawing.Size(40, 22)
        Me.TextBox5.TabIndex = 13
        Me.TextBox5.Text = "100"
        '
        'Label4
        '
        Me.Label4.Location = New System.Drawing.Point(16, 72)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(104, 24)
        Me.Label4.TabIndex = 14
        Me.Label4.Text = "update rate (ms)"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
        Me.ClientSize = New System.Drawing.Size(632, 440)
        Me.Controls.Add(Me.Label4)
        Me.Controls.Add(Me.TextBox5)
        Me.Controls.Add(Me.SetSpeed2)
        Me.Controls.Add(Me.TextBox4)
        Me.Controls.Add(Me.SetSpeed1)
        Me.Controls.Add(Me.Label3)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.TextBox3)
        Me.Controls.Add(Me.TextBox2)
        Me.Controls.Add(Me.TextBox1)
        Me.Controls.Add(Me.Disconnect)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.ConnectOPC)
        Me.Name = "Form1"
        Me.Text = "Yaskawa MP2300Siec OPC Demo"
        Me.ResumeLayout(False)

    End Sub

#End Region


    Private Sub ConnectOPC_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ConnectOPC.Click
        

        ' Connect to the KW OPC Server
        Try
            OpcSrv = New OpcServer
            OpcSrv.Connect("OPC.OUT.PCOS.21")
            srwGroup = New SyncIOGroup(OpcSrv)
            
            Timer1.Enabled = True
        Catch ex As Exception
            OpcSrv = Nothing
            Label1.Text = ex.Message
        End Try

    End Sub


    Private Sub Disconnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Disconnect.Click
        Timer1.Enabled = False
        'remove group
        srwGroup.Dispose()
        srwGroup = Nothing
        ' Disconnect from the OPC Server
        OpcSrv.Disconnect()
        OpcSrv = Nothing
        Label1.Text = "Not Connected..."
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        
        Dim Rslt_0 As OPCItemState
        Dim rtc_0 As Int32
        Dim retVal_0 As String

        Dim Rslt_1 As OPCItemState
        Dim rtc_1 As Int32
        Dim retVal_1 As String

        Dim Rslt_2 As OPCItemState
        Dim rtc_2 As Int32
        Dim retVal_2 As String

        rtc_0 = srwGroup.Read(OPCDATASOURCE.OPC_DS_CACHE, _
                                "TestResource.PLC_SYS_TICK_CNT", Rslt_0)
        rtc_1 = srwGroup.Read(OPCDATASOURCE.OPC_DS_CACHE, _
                                "TestResource.position1", Rslt_1)
        rtc_2 = srwGroup.Read(OPCDATASOURCE.OPC_DS_CACHE, _
                                "TestResource.position2", Rslt_2)

        srwGroup.OpcGrp.UpdateRate = TextBox5.Text

        '-------------------------------
        If HRESULTS.Failed(rtc_0) Then
            retVal_0 = "Read error"
        Else
            retVal_0 = Rslt_0.DataValue.ToString()
        End If
        Label1.Text = "Connected to OPC " + retVal_0
        '-------------------------------
        If HRESULTS.Failed(rtc_1) Then
            retVal_1 = "Read error"
        Else
            retVal_1 = Format(Rslt_1.DataValue, "#.000")
        End If
        TextBox1.Text = retVal_1

        '-------------------------------
        If HRESULTS.Failed(rtc_2) Then
            retVal_2 = "Read error"
        Else
            retVal_2 = Format(Rslt_2.DataValue, "#.000")
        End If
        TextBox2.Text = retVal_2

    End Sub

    Private Sub Form1_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        Timer1.Enabled = False

        'remove groups
        If Not srwGroup Is Nothing Then
            srwGroup.Dispose()
            srwGroup = Nothing
        End If
        ' Disconnect from the OPC Server
        If Not OpcSrv Is Nothing Then
            OpcSrv.Disconnect()
            OpcSrv = Nothing
        End If
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub SetSpeed1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetSpeed1.Click
        Dim val As Long
        Dim rtc As Int32
        Dim retVal As String
        val = TextBox3.Text
        rtc = srwGroup.Write("TestResource.Jog_Speed1", val)
    End Sub

    Private Sub SetSpeed2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SetSpeed2.Click
        Dim val As Long
        Dim rtc As Int32
        Dim retVal As String
        val = TextBox4.Text
        rtc = srwGroup.Write("TestResource.Jog_Speed2", val)
    End Sub

End Class
